/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
	WARNING
	Do not edit this file, it is generated.
 */

package uk.co.gardennotebook;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javafx.event.Event;
import javafx.scene.Node;

/**
 *	Functionality required by all the panes, etc shown in the UI
 * 
 * @author Andrew Gegg
*	@version	1.0
*	@since	1.0
 */
public interface INotebookLoadable
{
	/**
	 * tidy up when the tab is closed
	 * @param event the close event
	 */
	default void clearUpOnClose(Event event)
	{
		
	}
	void setLoadSplit(Consumer<Node> code);
	void setClearSplit(Consumer<Node> code);
	void setLoadTab(BiConsumer<String, Node> code);
	void setClearTab(Consumer<Node> code);
}
