/*
 * Copyright (C) 2018, 2023 Andrew Gegg
 
 *
 *   This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software:  you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	Change log
    2.4.0   Force Alert always on top
    3.1.1	Accept a Throwable, not just an Exception to support last gasp Exception handling
 */

package uk.co.gardennotebook;

import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.stage.Stage;

/**
 *	If the underlying persistence engine (e.g. database) throws an error there is
 *	usually very little that can be done by the client code (i.e. this application!)
 *	This class displays an error to the user then closes down.
 * 
 * @author Andy Gegg
*	@version	2.4.0
*	@since	1.1.0
 */
final class PanicHandler {

	private PanicHandler() {}

//	final static void panic(Exception ex)
	static void panic(Throwable ex)
	{
		Alert alert = new Alert(Alert.AlertType.ERROR, ex.getLocalizedMessage(), ButtonType.OK);

        // Force the Alert to be always on top - errors thrown in initialisation can end up behind the TopController window
        Stage stage = (Stage) alert.getDialogPane().getScene().getWindow();
        stage.setAlwaysOnTop(true);
        alert.showAndWait();
		Platform.exit();
	}
}
