/*
 * Copyright (C) 2021 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
	Change log
	3.0.0	First version
 */

package uk.co.gardennotebook;

import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.EntryMessage;
import uk.co.gardennotebook.fxbean.AfflictionBean;
import uk.co.gardennotebook.spi.*;

import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

/**
 * The controller class for the Planning tab
 *
 * @author Andy Gegg
*	@version	3.0.0
*	@since	3.0.0
 */
final class PlanningCatalogues extends AnchorPane implements  INotebookLoadable {

	private static final Logger LOGGER = LogManager.getLogger();

	@FXML
	private ResourceBundle resources;

	private Consumer<Node> loadSplit;
	private Consumer<Node> clearSplit;
	private BiConsumer<String, Node> loadTab;
	private Consumer<Node> clearTab;

	PlanningCatalogues()
	{
        FXMLLoader fxmlLoader = new FXMLLoader(getClass().getResource("/fxml/PlanningCatalogues.fxml"),
			ResourceBundle.getBundle("notebook"));
        fxmlLoader.setRoot(this);
        fxmlLoader.setController(this);

        try {
            fxmlLoader.load();
        } catch (IOException exception) {
            throw new RuntimeException(exception);
        }
	}

	@Override
	public void setLoadSplit(Consumer<Node> code)
	{
		loadSplit = code;
	}
	
	@Override
	public void setClearSplit(Consumer<Node> code)
	{
		clearSplit = code;
	}
	
	@Override
	public void setLoadTab(BiConsumer<String, Node> code)
	{
		loadTab = code;
	}
	
	@Override
	public void setClearTab(Consumer<Node> code) {
		clearTab = code;
	}
    
	@FXML
    private void btnCropRotationGroupCatOnAction(ActionEvent event)
	{
		EntryMessage log4jEntryMsg = LOGGER.traceEntry("btnTopPlanningOnAction()");
		CropRotationGroupCat customTest = new CropRotationGroupCat();
		loadTab.accept(resources.getString("tab.croprotationgroup"), customTest);
	}

    @FXML
    private void btnPlanningCatOnAction(ActionEvent event) {
		CroppingPlanCat customTest = new CroppingPlanCat();
		loadTab.accept(resources.getString("tab.croppingplan"), customTest);
		ITrug server = TrugServer.getTrugServer().getTrug();
		ICroppingActualLister gal = server.getCroppingActualLister();
		try
		{
			List<? extends ICroppingActual> ll = gal.fetch();
		}
		catch (GNDBException e)
		{
			e.printStackTrace();
		}
	}

	@FXML
	private void btnLocationsCatOnAction(ActionEvent event) {
		LocationCat customTest = new LocationCat();
		loadTab.accept(resources.getString("tab.locationcatalogue"), customTest);
	}

	@FXML
	private void tabOnCloseRequest(Event e)
	{
		clearSplit.accept(this);
	}


}
