/*
 * Copyright (C) 2018 Andrew Gegg
 
 *
 *   This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software:  you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	This file is NOT generated.
 */

package uk.co.gardennotebook;

import java.net.URL;
import java.util.ResourceBundle;
//import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Callback;
import javafx.util.StringConverter;
import uk.co.gardennotebook.spi.ReminderIntervalType;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.EntryMessage;


final public class ReminderIntervalCombo extends ComboBox<ReminderIntervalType> 
{

	private static final Logger LOGGER = LogManager.getLogger();

	private ResourceBundle resources;
	
	public ReminderIntervalCombo() {
		this(null, null);
	}

	public ReminderIntervalCombo(ResourceBundle resources) 
	{
		this(resources, null);
	}

	public ReminderIntervalCombo(ResourceBundle resources, ReminderIntervalType currVal)
	{
		LOGGER.debug("RepeatIntervalCombo: constructor: currVal: {}", currVal);
		this.resources = resources;
		getItems().addAll(ReminderIntervalType.values());
		setCellFactory(new Callback<ListView<ReminderIntervalType>, ListCell<ReminderIntervalType>>() 
		{
			@Override
			public ListCell<ReminderIntervalType> call(ListView<ReminderIntervalType> p) {
				return new ListCell<ReminderIntervalType>() {
					@Override
					protected void updateItem(ReminderIntervalType item, boolean empty) {
						super.updateItem(item, empty);
						setGraphic(null);
						if (item == null || empty) {
							setText(null);
						} else {
							setText(item.getDisplayName(getResources()));
						}
					}
				};
			}
		});
		setConverter(new StringConverter<ReminderIntervalType>()
		{
			@Override
			public String toString(ReminderIntervalType object) {
				if (object == null) {
					return null;
				}
				return object.getDisplayName(getResources());
			}

			@Override
			public ReminderIntervalType fromString(String string) {
//				if (string == null || string.isEmpty()) {
				if (string == null || string.isBlank()) {
					return null;
				}
				for (ReminderIntervalType rpt : ReminderIntervalType.values()) {
					if (rpt.name().equalsIgnoreCase(string)) {
						return rpt;
					}
					if (rpt.code().equalsIgnoreCase(string)) {
						return rpt;
					}
					if (rpt.getDisplayName(getResources()).equalsIgnoreCase(string)) {
						return rpt;
					}
				}
				return null;
			}
		});
		if (currVal != null) {
			for (ReminderIntervalType rpt : getItems()) 
			{
				LOGGER.debug("RepeatIntervalCombo: constructor: initial selection loop: for: {}", rpt);
				if (rpt == currVal)
				{
					setValue(rpt);
					break;
				}
			}
		}
	}

	/*
	* When this combo is added through FXML the no-args constructor is used so the calling controller
		must use setResources() explicitly.  However, the string converters set in the constructor
		will not notice a changed value of resources if the actual field is hard coded.  Therefore,
		we have to resort to the roundabout method of calling a function to fetch the current value.
	*/
	private ResourceBundle getResources()
	{
		return resources;
	}

	/**
	 * When this combo is added through FXML the no-args constructor is used so the calling controller
	 *	must use setResources() explicitly. 
	 * 
	 * @param resources	the new ResourceBundle to use
	 */	
	void setResources(ResourceBundle resources)
	{
		this.resources = resources;
	}

}
