/*
* Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	This file is NOT generated.
 */

package uk.co.gardennotebook.spi;

/**
 *	An unchecked exception used as a translation for GNDBException in situations where
 *	a checked exception cannot be thrown - e.g. from a ChangeListener handler
 * 
 * Check the Cause for further info.
 * 
 * @author Andrew Gegg
*	@version	1.1.0
*	@since	1.1.0
 */
public class GNDBRuntimeException extends RuntimeException
{
	private int errno = 0;
	private String SQLState = "";
	
/**
 * Translate an underlying DB (or other) exception into a product known exception.
 * 
 * @param cause The throwable which gave rise to this exception.
 */	
	public GNDBRuntimeException(Throwable cause)
	{
		super(cause);
	}
	
/**
 * Translate an underlying DB (or other) exception into a product known exception.
 * 
 * @param cause The throwable which gave rise to this exception.
 * @param errno	The SQL (or other) error code
 * @param SQLState	The SQLState of the underlying problem 
 */	
	public GNDBRuntimeException(Throwable cause, int errno, String SQLState)
	{
		super(cause);
		this.errno = errno;
		this.SQLState = SQLState;
	}
	
	@Override
	public String getLocalizedMessage()
	{
		return getCause().getLocalizedMessage();
	}
	
    /**
     *  Return the underlying error code.
     *  Consult relevant RDBMS documentation for meaning.
     * 
     * @return  The SQL (or other) error code
     */
	public int getErrno()
	{
		return errno;
	}
	
    /**
     *  Return the SQLState value from the underlying RDBMS.
     *  Consult relevant RDBMS documentation for meaning.
     * 
     * @return  The SQLState of the underlying problem
     */
	public String getSQLState()
	{
		return SQLState;
	}
}
