/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	Do not edit this file, it is generated.
 */

package uk.co.gardennotebook.spi;

import java.util.List;

import java.time.*;

/**
Various types of notes, such as cultivation notes, too long for or not best organised as comments.
*/
public interface IPlantNoteLister
{
	/**
	*	Returns the PlantNote entries matching the given criteria.
	*	If no criteria have been specified all PlantNote entries will be returned.
	*	Criteria are applied additively (i.e. criterion AND criterion).
	*
	*	@return	A list of PlantNote entries matching previously specified criteria.
	*
	*	@throws	GNDBException	If the underlying persistence store (e.g. a database) throws an exception.
	*			The causal Exception can be retrieved via <code>getCause()</code>
	*/
	public List<IPlantNote> fetch() throws GNDBException;

	/**
	*	Select only these PlantNote entries
	*	May be called repeatedly to add to the list of PlantNote entries to be returned
	*
	*	@param items	the list of PlantNote entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IPlantNoteLister plantNote(IPlantNote... items);

	/**
	*	Select only these PlantNote entries
	*	May be called repeatedly to add to the list of PlantNote entries to be returned
	*
	*	@param items	the list of PlantNote entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IPlantNoteLister plantNote(List<IPlantNote> items);

	/**
	*	Select only those PlantNote entries which are for these PlantSpecies entries.
	*	May be called repeatedly to add to the list of PlantSpecies entries to be selected.
	*	If PlantSpecies and PlantVariety lists are BOTH supplied, PlantNote entries matching either will be selected.
	*
	*	@param items	the list of PlantSpecies items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IPlantNoteLister plantSpecies(IPlantSpecies... items);

	/**
	*	Select only those PlantNote entries which are for these PlantSpecies entries.
	*	May be called repeatedly to add to the list of PlantSpecies entries to be selected
	*	If PlantSpecies and PlantVariety lists are BOTH supplied, PlantNote entries matching either will be selected.
	*
	*	@param items	the list of PlantSpecies items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IPlantNoteLister plantSpecies(List<IPlantSpecies> items);

	/**
	*	Select only those PlantNote entries which are for these PlantVariety entries.
	*	May be called repeatedly to add to the list of PlantVariety entries to be selected.
	*	If PlantSpecies and PlantVariety lists are BOTH supplied, PlantNote entries matching either will be selected.
	*
	*	@param items	the list of PlantVariety items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IPlantNoteLister plantVariety(IPlantVariety... items);

	/**
	*	Select only those PlantNote entries which are for these PlantVariety entries.
	*	May be called repeatedly to add to the list of PlantVariety entries to be selected
	*	If PlantSpecies and PlantVariety lists are BOTH supplied, PlantNote entries matching either will be selected.
	*
	*	@param items	the list of PlantVariety items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IPlantNoteLister plantVariety(List<IPlantVariety> items);

}
