/*
 * Copyright (C) 2018, 2019 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	Change log
	2.0.1   Change from old 'key()' to 'plantSpecies() selection
	3.0.0	Implement CropRotationGroup
 */

package uk.co.gardennotebook.spi;

import java.util.List;

/**
A species of plant grown in the garden, for instance, 'tomato'.  A species will have zero or more varieties.<BR>
Note the use of a Trigger to reflect changes to commonName into Product.
*/
public interface IPlantSpeciesLister
{
	/**
	*
	*	Returns the PlantSpecies entries matching the given criteria
	*	If no criteria have been specified all PlantSpecies entries will be returned
	*	Criteria are applied additively (i.e. criterion AND criterion)
	*
	*	@return	A list of PlantSpecies entries matching previously specified criteria
	*
	*	@throws	GNDBException	If the underlying persistence store (e.g. a database) throws an exception.
	*			The causal Exception can be retrieved via <code>getCause()</code>
	*/
	public List<IPlantSpecies> fetch() throws GNDBException;

	/**
	*
	*	Select only these PlantSpecies entries
	*	May be called repeatedly to add to the list of PlantSpecies entries to be returned
	*
	*	@param items	the list of PlantSpecies entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
//	public IPlantSpeciesLister key(IPlantSpecies... items);
	public IPlantSpeciesLister plantSpecies(IPlantSpecies... items);    //  2.0.1

	/**
	*
	*	Select only these PlantSpecies entries
	*	May be called repeatedly to add to the list of PlantSpecies entries to be returned
	*
	*	@param items	the list of PlantSpecies entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
    public IPlantSpeciesLister plantSpecies(List<IPlantSpecies> items); //  2.0.1
//	public IPlantSpeciesLister key(List<IPlantSpecies> items);

	/**
	 *	Select only the PlantSpecies in these crop rotation groups.
	 *
	 * @param	items	the list of CropRotationGroups
	* @return	this Lister
	 */
	public IPlantSpeciesLister cropRotationGroup(ICropRotationGroup... items);

	/**
	 *	Select only the PlantSpecies in these crop rotation groups.
	 *
	 * @param	items	the list of CropRotationGroups
	 * @return	this Lister
	 */
	public IPlantSpeciesLister cropRotationGroup(List<ICropRotationGroup> items);

	/**
	*	Select only the PlantSpecies entries with these commonName values.
	*	May be called repeatedly to add to the list of commonName entries to be selected
	*
	*	@param items	the list of commonName values.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IPlantSpeciesLister commonName(String... items);

}
