/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	Do not edit this file, it is generated.
 */

package uk.co.gardennotebook.spi;

import java.beans.PropertyChangeListener;
import java.util.List;
import java.time.*;

import java.util.Optional;

/**
*	A purchasable product.
*
*	@author	Andy Gegg
*	@version	1.0
*	@since	1.0
*/
public interface IProduct extends INotebookEntry
{
	/**
	*	The owning ProductCategory.
	*
	*	@return	the ProductCategory
	*/
	public IProductCategory getProductCategory();

	/**
	*	The owning PlantSpecies.
	*
	*	@return	the PlantSpecies
	*/
	public Optional<IPlantSpecies> getPlantSpecies();

	/**
	*	The owning PlantVariety.
	*
	*	@return	the PlantVariety
	*/
	public Optional<IPlantVariety> getPlantVariety();

	/**
	*	The owning ProductBrand.
	*
	*	@return	the ProductBrand
	*/
	public Optional<IProductBrand> getProductBrand();

	/**
	*	Get the value of name.
	*
	*	@return	the value of name
	*/
	public String getName();

	/**
	*	Get the value of nameDetail_1 (if present).
	*
	*	@return	the value of nameDetail_1
	*/
	public Optional<String> getNameDetail_1();

	/**
	*	Get the value of nameDetail_2 (if present).
	*
	*	@return	the value of nameDetail_2
	*/
	public Optional<String> getNameDetail_2();

	/**
	*	Get the value of description (if present).
	*
	*	@return	the value of description
	*/
	public Optional<String> getDescription();

	/**
	*	Get the value of lastUpdated.
	*
	*	@return	the value of lastUpdated
	*/
	public LocalDateTime getLastUpdated();

	/**
	*	Get the value of created.
	*
	*	@return	the value of created
	*/
	public LocalDateTime getCreated();


	/**
	*	Get the PurchaseItem entries for this Product.
	*
	*	@return	 a lister for the PurchaseItem entries
	*/
	public IPurchaseItemLister getPurchaseItem();

	/**
	*	Get the RetailerHasProduct entries for this Product.
	*
	*	@return	 a lister for the RetailerHasProduct entries
	*/
	public IRetailerHasProductLister getRetailerHasProduct();

	/**
	*	Get the ShoppingList entries for this Product.
	*
	*	@return	 a lister for the ShoppingList entries
	*/
	public IShoppingListLister getShoppingList();

	/**
	*	Add a change listener to the Product.
	*
	*	@param	propertyName	identifies the change being flagged.  One of:<UL>
	*			<LI>deleted	-	this object has been deleted from the database, oldValue is the deleted object
	*			<LI>replaced	-	this object has been replaced in the database, oldValue is the deleted object, newValue its replacement
	*			<LI>Comment	-	this comment has been added to or deleted from this Product, newValue is an added comment, oldValue is a deleted comment
	*			<LI>PurchaseItem	-	this PurchaseItem has been added to or deleted from this Product's children, newValue is an added object, oldValue is the deleted object
	*			<LI>RetailerHasProduct	-	this RetailerHasProduct has been added to or deleted from this Product's children, newValue is an added object, oldValue is the deleted object
	*			<LI>ShoppingList	-	this ShoppingList has been added to or deleted from this Product's children, newValue is an added object, oldValue is the deleted object
	</UL>
	*	@param	listener	a PropertyChangeListener (may be a Lambda expression)
	*/
	public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener);

	/**
	*	Remove a change listener from the Product.
	*
	*	@param	propertyName	identifies the change being flagged.  One of:<UL>
	*			<LI>deleted	-	this object has been deleted from the database, oldValue is the deleted object
	*			<LI>replaced	-	this object has been replaced in the database, oldValue is the deleted object, newValue its replacement
	*			<LI>Comment	-	this comment has been added to or deleted from this Product, newValue is an added comment, oldValue is a deleted comment
	*			<LI>PurchaseItem	-	this PurchaseItem has been added to or deleted from this Product's children, newValue is an added object, oldValue is the deleted object
	*			<LI>RetailerHasProduct	-	this RetailerHasProduct has been added to or deleted from this Product's children, newValue is an added object, oldValue is the deleted object
	*			<LI>ShoppingList	-	this ShoppingList has been added to or deleted from this Product's children, newValue is an added object, oldValue is the deleted object
	</UL>
	*	@param	listener	the listener to remove
	*/
	public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener);

	/**
	*	Signal to all listeners that this Product has been deleted.
	*
	*/
	public void flagDeleted();

	/**
	*	Signal to all listeners that this Product has been replaced.
	*
	*	@param	newValue	the replacement Product
	*/
	public void flagReplaced(IProduct newValue);

	/**
	*	Signal to all listeners that a child has been deleted.
	*
	*	@param	child	this PurchaseItem is no longer a child of this Product
	*/
	public void flagChildDeleted(IPurchaseItem child);

	/**
	*	Signal to all listeners that a child has been added.
	*
	*	@param	child	this PurchaseItem has been added as a child of this Product
	*/
	public void flagChildAdded(IPurchaseItem child);

	/**
	*	Signal to all listeners that a child has been deleted.
	*
	*	@param	child	this RetailerHasProduct is no longer a child of this Product
	*/
	public void flagChildDeleted(IRetailerHasProduct child);

	/**
	*	Signal to all listeners that a child has been added.
	*
	*	@param	child	this RetailerHasProduct has been added as a child of this Product
	*/
	public void flagChildAdded(IRetailerHasProduct child);

	/**
	*	Signal to all listeners that a child has been deleted.
	*
	*	@param	child	this ShoppingList is no longer a child of this Product
	*/
	public void flagChildDeleted(IShoppingList child);

	/**
	*	Signal to all listeners that a child has been added.
	*
	*	@param	child	this ShoppingList has been added as a child of this Product
	*/
	public void flagChildAdded(IShoppingList child);

}

