/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	Do not edit this file, it is generated.
 */

package uk.co.gardennotebook.spi;

import uk.co.gardennotebook.util.StoryLineTree;
import java.util.List;
import java.time.*;

/**
*	A brand for one or more Products - such as Verve ({@literal B&Q} own brand)
*

*	Use this class to create, modify or delete an instance of ProductBrand

*/

public interface IProductBrandBuilder
{
	/**
	*	set the  Retailer parent
	*
	*	@param	newVal	the new value
	*	@return	 this Builder
	*/
	public IProductBrandBuilder retailer(IRetailer newVal);

	/**
	*	check if a value for name is already a key for an item of this type
	*
	*	@param	newVal	the value to check
	*	@return	true if the test value is already used as a unique key
	*
	*	@throws	GNDBException	if the underlying persisted storage engine (e.g. database server) throws an exception
	*				The original error can be retrieved by <code>getCause()</code>
	*/
	public boolean isNameDuplicate(String newVal) throws GNDBException;

	/**
	*	give the (new) value of name
	*
	*	@param	newVal	the new value
	*	@return	this Builder
	*	@throws	IllegalArgumentException	if newVal already exists as a name
	*	@throws	GNDBException	if the underlying persisted storage engine (e.g. database server) throws an exception
	*				The original error can be retrieved by <code>getCause()</code>
	*/
	public IProductBrandBuilder name(String newVal) throws IllegalArgumentException, GNDBException;

	/**
	*	give the (new) value of description
	*
	*	@param	newVal	the new value
	*	@return	this Builder
	*/
	public IProductBrandBuilder description(String newVal);

	/**
	*	Add this value as a comment; may be called multiple times
	*
	*	@param	newVals	the new value
	*	@return	this Builder
	*/
	public IProductBrandBuilder addComment(String... newVals);

	/**
	*	Add these values as new comments
	*
	*	@param	newVals	the new value
	*	@return	this Builder
	*/
	public IProductBrandBuilder addComment(List<String> newVals);

	/**
	*	remove one or more comments from this item
	*
	*	@param	oldVals	the comment to remove.  If the comment does not exist, this is a null-op
	*	@return	this Builder
	*/
	public IProductBrandBuilder deleteComment(IComment... oldVals);

	/**
	*	remove a comment from this item
	*
	*	@param	oldVals	the comment to remove.  If the comment does not exist, this is a null-op
	*	@return	this Builder
	*/
	public IProductBrandBuilder deleteComment(List<IComment> oldVals);

	/**
	*	modify a comment on this item
	*
	*	@param	base	the comment to modify.  If the comment does not exist, this is a null-op
	*	@param	comment	the replacement text
	*	@return	this Builder
	*/
	public IProductBrandBuilder changeComment(IComment base, String comment);

	/**
	*	modify a comment on this item
	*
	*	@param	base	the comment to modify.  If the comment does not exist, this is a null-op
	*	@param	date	the replacement date
	*	@return	 this Builder
	*/
	public IProductBrandBuilder changeComment(IComment base, LocalDate date);

	/**
	*	modify a comment on this item
	*
	*	@param	base	the comment to modify.  If the comment does not exist, this is a null-op
	*	@param	date	the replacement date
	*	@param	comment	the replacement text
	*	@return	this Builder
	*/
	public IProductBrandBuilder changeComment(IComment base, LocalDate date, String comment);

	/**
	*	Check if the new or changed item needs to be saved
	*	i.e. has anything been changed?
	*
	*	@see #canSave()
	*
	*	@return	true if {@code save()} should be called
	*			false if nothing has been changed
	*/
	public boolean needSave();

	/**
	*	Check if the new or changed item can be saved
	*	i.e. do all mandatory fields have a value?
	*
	*	@see #needSave()
	*
	*	@return	true if {@code save()} can be called safely
	*			false if there are unset mandatory values
	*/
	public boolean canSave();

	/**
	*	Persist the new or changed instance to permanent storage
	*
	*	@return	A reference to the newly created or updated object
	*
	*	@throws	GNDBException	if the underlying persisted storage engine (e.g. database server) throws an exception
	*				The original error can be retrieved by <code>getCause()</code>
	*/
	public IProductBrand save() throws GNDBException;

	/**
	*	Check if the item can be deleted
	*	i.e. are there any 'children' items?
	*
	*	@return	true if {@code delete()} can be called safely
	*			false if there are any 'children' items
	*
	*	@throws	GNDBException	if the underlying persisted storage engine (e.g. database server) throws an exception
	*				The original error can be retrieved by <code>getCause()</code>
	*/
	public boolean canDelete() throws GNDBException;

	/**
	*	Delete the instance from permanent storage
	*
	*	@throws	GNDBException	if the underlying persisted storage engine (e.g. database server) throws an exception
	*				The original error can be retrieved by <code>getCause()</code>
	*/
	public void delete() throws GNDBException;
	/**
	*	<p>Check if this item has any story line ancestors
	*
	*	@return	true if this ProductBrand has any ancestors
	*
	*	@throws	GNDBException	if the underlying persisted storage engine (e.g. database server) throws an exception
	*				The original error can be retrieved by <code>getCause()</code>
	*/
	public boolean hasAncestor() throws GNDBException;

	/**
	*	<p>Get the story line ancestors of this ProductBrand
	*
	*	@return	the story line ancestors of this ProductBrand
	*
	*	@throws	GNDBException	if the underlying persisted storage engine (e.g. database server) throws an exception
	*				The original error can be retrieved by <code>getCause()</code>
	*/
	public StoryLineTree<? extends INotebookEntry> getAncestors() throws GNDBException;

	/**
	*	<p>Set this PurchaseItem as the story line ancestor of this ProductBrand
	*This operation is only allowed if the currently specified ProductBrand does NOT have an ancestor
	*
	*	@param	ancestor	the PurchaseItem to be set as the ancestor
	*
	*	@return	this Builder
	*
	*	@throws	GNDBException	if the underlying persisted storage engine (e.g. database server) throws an exception
	*				The original error can be retrieved by <code>getCause()</code>
	*/
	public IProductBrandBuilder ancestor(IPurchaseItem ancestor) throws GNDBException;

	/**
	*	<p>Set this Groundwork as the story line ancestor of this ProductBrand
	*This operation is only allowed if the currently specified ProductBrand does NOT have an ancestor
	*
	*	@param	ancestor	the Groundwork to be set as the ancestor
	*
	*	@return	this Builder
	*
	*	@throws	GNDBException	if the underlying persisted storage engine (e.g. database server) throws an exception
	*				The original error can be retrieved by <code>getCause()</code>
	*/
	public IProductBrandBuilder ancestor(IGroundwork ancestor) throws GNDBException;

	/**
	*	<p>Set this AfflictionEvent as the story line ancestor of this ProductBrand
	*This operation is only allowed if the currently specified ProductBrand does NOT have an ancestor
	*
	*	@param	ancestor	the AfflictionEvent to be set as the ancestor
	*
	*	@return	this Builder
	*
	*	@throws	GNDBException	if the underlying persisted storage engine (e.g. database server) throws an exception
	*				The original error can be retrieved by <code>getCause()</code>
	*/
	public IProductBrandBuilder ancestor(IAfflictionEvent ancestor) throws GNDBException;

	/**
	*	<p>Set this Husbandry as the story line ancestor of this ProductBrand
	*This operation is only allowed if the currently specified ProductBrand does NOT have an ancestor
	*
	*	@param	ancestor	the Husbandry to be set as the ancestor
	*
	*	@return	this Builder
	*
	*	@throws	GNDBException	if the underlying persisted storage engine (e.g. database server) throws an exception
	*				The original error can be retrieved by <code>getCause()</code>
	*/
	public IProductBrandBuilder ancestor(IHusbandry ancestor) throws GNDBException;

	/**
	*	<p>Set this SaleItem as the story line ancestor of this ProductBrand
	*This operation is only allowed if the currently specified ProductBrand does NOT have an ancestor
	*
	*	@param	ancestor	the SaleItem to be set as the ancestor
	*
	*	@return	this Builder
	*
	*	@throws	GNDBException	if the underlying persisted storage engine (e.g. database server) throws an exception
	*				The original error can be retrieved by <code>getCause()</code>
	*/
	public IProductBrandBuilder ancestor(ISaleItem ancestor) throws GNDBException;

	/**
	*	check if this ProductBrand has any story line descendants
	*
	*	@return	true if this ProductBrand has any descendants
	*
	*	@throws	GNDBException	if the underlying persisted storage engine (e.g. database server) throws an exception
	*				The original error can be retrieved by <code>getCause()</code>
	*/
	public boolean hasDescendant() throws GNDBException;

	/**
	*	get the story line descendants of this ProductBrand
	*
	*	@return	the links for the descendants of this ProductBrand
	*
	*	@throws	GNDBException	if the underlying persisted storage engine (e.g. database server) throws an exception
	*				The original error can be retrieved by <code>getCause()</code>
	*/
	public StoryLineTree<? extends INotebookEntry> getDescendants() throws GNDBException;

	/**
	*	<p>Add a PurchaseItem as a story line descendant to this ProductBrand
	*
	*	@param	descendant	the PurchaseItem to be added as a descendant
	*
	*	@return	true if the operation was successful
	*
	*	@throws	GNDBException	if the underlying persisted storage engine (e.g. database server) throws an exception
	*				The original error can be retrieved by <code>getCause()</code>
	*/
	public boolean addDescendant(IPurchaseItem descendant) throws GNDBException;

	/**
	*	<p>Add a Groundwork as a story line descendant to this ProductBrand
	*
	*	@param	descendant	the Groundwork to be added as a descendant
	*
	*	@return	true if the operation was successful
	*
	*	@throws	GNDBException	if the underlying persisted storage engine (e.g. database server) throws an exception
	*				The original error can be retrieved by <code>getCause()</code>
	*/
	public boolean addDescendant(IGroundwork descendant) throws GNDBException;

	/**
	*	<p>Add a AfflictionEvent as a story line descendant to this ProductBrand
	*
	*	@param	descendant	the AfflictionEvent to be added as a descendant
	*
	*	@return	true if the operation was successful
	*
	*	@throws	GNDBException	if the underlying persisted storage engine (e.g. database server) throws an exception
	*				The original error can be retrieved by <code>getCause()</code>
	*/
	public boolean addDescendant(IAfflictionEvent descendant) throws GNDBException;

	/**
	*	<p>Add a Husbandry as a story line descendant to this ProductBrand
	*
	*	@param	descendant	the Husbandry to be added as a descendant
	*
	*	@return	true if the operation was successful
	*
	*	@throws	GNDBException	if the underlying persisted storage engine (e.g. database server) throws an exception
	*				The original error can be retrieved by <code>getCause()</code>
	*/
	public boolean addDescendant(IHusbandry descendant) throws GNDBException;

	/**
	*	<p>Add a SaleItem as a story line descendant to this ProductBrand
	*
	*	@param	descendant	the SaleItem to be added as a descendant
	*
	*	@return	true if the operation was successful
	*
	*	@throws	GNDBException	if the underlying persisted storage engine (e.g. database server) throws an exception
	*				The original error can be retrieved by <code>getCause()</code>
	*/
	public boolean addDescendant(ISaleItem descendant) throws GNDBException;

}

