/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	Do not edit this file, it is generated.
 */

package uk.co.gardennotebook.spi;

import java.util.List;

import java.time.*;

/**
A brand for one or more Products - such as Verve ({@literal B&Q} own brand)
*/
public interface IProductBrandLister
{
	/**
	*	Returns the ProductBrand entries matching the given criteria.
	*	If no criteria have been specified all ProductBrand entries will be returned.
	*	Criteria are applied additively (i.e. criterion AND criterion).
	*
	*	@return	A list of ProductBrand entries matching previously specified criteria.
	*
	*	@throws	GNDBException	If the underlying persistence store (e.g. a database) throws an exception.
	*			The causal Exception can be retrieved via <code>getCause()</code>
	*/
	public List<IProductBrand> fetch() throws GNDBException;

	/**
	*	Select only these ProductBrand entries
	*	May be called repeatedly to add to the list of ProductBrand entries to be returned
	*
	*	@param items	the list of ProductBrand entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IProductBrandLister productBrand(IProductBrand... items);

	/**
	*	Select only these ProductBrand entries
	*	May be called repeatedly to add to the list of ProductBrand entries to be returned
	*
	*	@param items	the list of ProductBrand entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IProductBrandLister productBrand(List<IProductBrand> items);

	/**
	*	Select only those ProductBrand entries which are for these Retailer entries.
	*	May be called repeatedly to add to the list of Retailer entries to be selected.
	*
	*	@param items	the list of Retailer items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IProductBrandLister retailer(IRetailer... items);

	/**
	*	Select only those ProductBrand entries which are for these Retailer entries.
	*	May be called repeatedly to add to the list of Retailer entries to be selected
	*
	*	@param items	the list of Retailer items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IProductBrandLister retailer(List<IRetailer> items);

	/**
	*	Select only the ProductBrand entries with these names
	*	May be called repeatedly to add to the list of names to be selected
	*
	*	@param items	the list of name values.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IProductBrandLister name(String... items);

}
