/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	Do not edit this file, it is generated.
 */

package uk.co.gardennotebook.spi;

import java.util.List;

import java.time.*;

/**
Implements the many-many link between retailers and products.  Many products, particularly own-brand products will only have a single supplier, others may be available from many retailers.
*/
public interface IRetailerHasProductLister
{
	/**
	*	Returns the RetailerHasProduct entries matching the given criteria.
	*	If no criteria have been specified all RetailerHasProduct entries will be returned.
	*	Criteria are applied additively (i.e. criterion AND criterion).
	*
	*	@return	A list of RetailerHasProduct entries matching previously specified criteria.
	*
	*	@throws	GNDBException	If the underlying persistence store (e.g. a database) throws an exception.
	*			The causal Exception can be retrieved via <code>getCause()</code>
	*/
	public List<IRetailerHasProduct> fetch() throws GNDBException;

	/**
	*	Select only these RetailerHasProduct entries
	*	May be called repeatedly to add to the list of RetailerHasProduct entries to be returned
	*
	*	@param items	the list of RetailerHasProduct entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IRetailerHasProductLister retailerHasProduct(IRetailerHasProduct... items);

	/**
	*	Select only these RetailerHasProduct entries
	*	May be called repeatedly to add to the list of RetailerHasProduct entries to be returned
	*
	*	@param items	the list of RetailerHasProduct entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IRetailerHasProductLister retailerHasProduct(List<IRetailerHasProduct> items);

	/**
	*	Select only those RetailerHasProduct entries which are for these Product entries.
	*	May be called repeatedly to add to the list of Product entries to be selected.
	*
	*	@param items	the list of Product items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IRetailerHasProductLister product(IProduct... items);

	/**
	*	Select only those RetailerHasProduct entries which are for these Product entries.
	*	May be called repeatedly to add to the list of Product entries to be selected
	*
	*	@param items	the list of Product items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IRetailerHasProductLister product(List<IProduct> items);

	/**
	*	Select only those RetailerHasProduct entries which are for these Retailer entries.
	*	May be called repeatedly to add to the list of Retailer entries to be selected.
	*
	*	@param items	the list of Retailer items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IRetailerHasProductLister retailer(IRetailer... items);

	/**
	*	Select only those RetailerHasProduct entries which are for these Retailer entries.
	*	May be called repeatedly to add to the list of Retailer entries to be selected
	*
	*	@param items	the list of Retailer items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IRetailerHasProductLister retailer(List<IRetailer> items);

}
