/*
 * Copyright (C) 2018, 2021 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	Change log
	3.0.0	Support 'watch for' entries for Purchase Items
 */

package uk.co.gardennotebook.spi;

import java.util.List;

import java.time.*;

/**
A list of tasks to be done.  Reminders are scheduled, possibly repeating and will create items here when they are due.<BR>
@apiNote
This list is not user updated - users create reminders which generate todo items
*/
public interface IToDoListLister
{
	/**
	*	Returns the ToDoList entries matching the given criteria.
	*	If no criteria have been specified all ToDoList entries will be returned.
	*	Criteria are applied additively (i.e. criterion AND criterion).
	*
	*	@return	A list of ToDoList entries matching previously specified criteria.
	*
	*	@throws	GNDBException	If the underlying persistence store (e.g. a database) throws an exception.
	*			The causal Exception can be retrieved via <code>getCause()</code>
	*/
	public List<IToDoList> fetch() throws GNDBException;

	/**
	*	Select only these ToDoList entries
	*	May be called repeatedly to add to the list of ToDoList entries to be returned
	*
	*	@param items	the list of ToDoList entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IToDoListLister toDoList(IToDoList... items);

	/**
	*	Select only these ToDoList entries
	*	May be called repeatedly to add to the list of ToDoList entries to be returned
	*
	*	@param items	the list of ToDoList entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IToDoListLister toDoList(List<IToDoList> items);

	/**
	*	Select only those ToDoList entries which are for these Husbandry entries.
	*	May be called repeatedly to add to the list of Husbandry entries to be selected.
	*
	*	@param items	the list of Husbandry items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IToDoListLister husbandry(IHusbandry... items);

	/**
	*	Select only those ToDoList entries which are for these Husbandry entries.
	*	May be called repeatedly to add to the list of Husbandry entries to be selected
	*
	*	@param items	the list of Husbandry items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IToDoListLister husbandry(List<IHusbandry> items);

	/**
	 *	Select only those ToDoList entries which are for these Purchase items.
	 *	May be called repeatedly to add to the list of Purchase items to be selected.
	 *
	 *	@param items	the list of HPurchase items.  A null value or empty list is a null-op
	 *	@return	this Lister
	 */
	public IToDoListLister purchaseItem(IPurchaseItem... items);

	/**
	 *	Select only those ToDoList entries which are for these Purchase items.
	 *	May be called repeatedly to add to the list of Purchase items to be selected
	 *
	 *	@param items	the list of Purchase items.  A null value or empty list is a null-op
	 *	@return	this Lister
	 */
	public IToDoListLister purchaseItem(List<IPurchaseItem> items);

	/**
	*	Select only those ToDoList entries which are for these HusbandryClass entries.
	*	May be called repeatedly to add to the list of HusbandryClass entries to be selected.
	*
	*	@param items	the list of HusbandryClass items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IToDoListLister husbandryClass(IHusbandryClass... items);

	/**
	*	Select only those ToDoList entries which are for these HusbandryClass entries.
	*	May be called repeatedly to add to the list of HusbandryClass entries to be selected
	*
	*	@param items	the list of HusbandryClass items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IToDoListLister husbandryClass(List<IHusbandryClass> items);

	/**
	*	Select only those ToDoList entries which are for these PlantSpecies entries.
	*	May be called repeatedly to add to the list of PlantSpecies entries to be selected.
	*	If PlantSpecies and PlantVariety lists are BOTH supplied, ToDoList entries matching either will be selected.
	*
	*	@param items	the list of PlantSpecies items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IToDoListLister plantSpecies(IPlantSpecies... items);

	/**
	*	Select only those ToDoList entries which are for these PlantSpecies entries.
	*	May be called repeatedly to add to the list of PlantSpecies entries to be selected
	*	If PlantSpecies and PlantVariety lists are BOTH supplied, ToDoList entries matching either will be selected.
	*
	*	@param items	the list of PlantSpecies items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IToDoListLister plantSpecies(List<IPlantSpecies> items);

	/**
	*	Select only those ToDoList entries which are for these PlantVariety entries.
	*	May be called repeatedly to add to the list of PlantVariety entries to be selected.
	*	If PlantSpecies and PlantVariety lists are BOTH supplied, ToDoList entries matching either will be selected.
	*
	*	@param items	the list of PlantVariety items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IToDoListLister plantVariety(IPlantVariety... items);

	/**
	*	Select only those ToDoList entries which are for these PlantVariety entries.
	*	May be called repeatedly to add to the list of PlantVariety entries to be selected
	*	If PlantSpecies and PlantVariety lists are BOTH supplied, ToDoList entries matching either will be selected.
	*
	*	@param items	the list of PlantVariety items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IToDoListLister plantVariety(List<IPlantVariety> items);

	/**
	*	Select only those ToDoList entries which are for these GroundworkActivity entries.
	*	May be called repeatedly to add to the list of GroundworkActivity entries to be selected.
	*
	*	@param items	the list of GroundworkActivity items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IToDoListLister groundworkActivity(IGroundworkActivity... items);

	/**
	*	Select only those ToDoList entries which are for these GroundworkActivity entries.
	*	May be called repeatedly to add to the list of GroundworkActivity entries to be selected
	*
	*	@param items	the list of GroundworkActivity items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IToDoListLister groundworkActivity(List<IGroundworkActivity> items);

}
