/*
 * Copyright (C) 2018-2020, 2023 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
*	Change log
*	2.1.0	renamed
*   2.9.0   include java.naming or an error is thrown if MySQL is on the CLASS_PATH
*   3.1.0   Use jakarta implementation of JSON
*   3.2.1   Include hsqldb as part of the build
*/

/**
 *
 * @author	Andrew Gegg
 * @version	3.2.1
 * @since	2.0.0
 */

module sqlimpl {
    
    provides uk.co.gardennotebook.spi.ITrug with uk.co.gardennotebook.mysql.SQLTrug;
    
    uses java.sql.Driver;
    
    requires utils;
    requires spi;
    requires jakarta.json;

    requires java.desktop;
    
    requires java.sql;
    requires java.sql.rowset;   //  required for MariaDB above 2.7.0 but below 3.0.2-rc
//    requires java.prefs;      // imported transitively through spi
    
    requires java.naming;       // required if MySQL is in the class path
    requires java.management;   // for MariaDB

    requires org.hsqldb;
}
