/*
 *
 *  Copyright (C) 2023, 2024 Andrew Gegg
 *
 * 	This file is part of the Gardeners Notebook application
 *
 *  The Gardeners Notebook application is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 *
 *
 */

 /*
    Change log
    3.2.1   Support selection by Location
 */

package uk.co.gardennotebook.mysql;

import uk.co.gardennotebook.spi.*;

import java.time.LocalDate;
import java.util.Optional;

/**
 *{@inheritDoc}
 *
 *	@author	Andy Gegg
 *	@version	3.2.1
 *	@since	3.2.0
 */
record LifecycleAnalysis(LocalDate date,
                                int ancestorId, NotebookEntryType ancestorType,
                                int plantSpeciesId, int plantVarietyId,
                                NotebookEntryType childType,
                                int husbandryId,
                                int afflictionEventId,
                                int groundworkId,
                                int locationId, boolean targetLocation) implements ILifecycleAnalysis
{
    public Optional<IHusbandry> ancestorHusbandry()
    {
        if (ancestorType != NotebookEntryType.HUSBANDRY)
            return Optional.empty();
        return Optional.ofNullable( MySQLCache.cacheHusbandry.get(ancestorId));
    }
    public Optional<IGroundwork> ancestorGroundwork()
    {
        if (ancestorType != NotebookEntryType.GROUNDWORK)
            return Optional.empty();
        return Optional.ofNullable( MySQLCache.cacheGroundwork.get(ancestorId));
    }
    public Optional<IAfflictionEvent> ancestorAfflictionEvent()
    {
        if (ancestorType != NotebookEntryType.AFFLICTIONEVENT)
            return Optional.empty();
        return Optional.ofNullable( MySQLCache.cacheAfflictionEvent.get(ancestorId));
    }
    @Override
    public Optional<IHusbandry> husbandry()
    {
//        System.out.println("Fetching Husbandry");
        if (husbandryId <= 0)
            return Optional.empty();
        return Optional.ofNullable(MySQLCache.cacheHusbandry.get(husbandryId));
    }

    @Override
    public Optional<IAfflictionEvent> afflictionEvent()
    {
        if (afflictionEventId <= 0)
            return Optional.empty();
        return Optional.ofNullable(MySQLCache.cacheAfflictionEvent.get(afflictionEventId));
    }

    @Override
    public Optional<IGroundwork> groundwork()
    {
        if (groundworkId <= 0)
            return Optional.empty();
        return Optional.ofNullable(MySQLCache.cacheGroundwork.get(groundworkId));
    }

    @Override
    public IPlantSpecies plantSpecies()
    {
        if (plantSpeciesId <= 0)
            return null;
        return MySQLCache.cachePlantSpecies.get(plantSpeciesId);
    }

    @Override
    public Optional<IPlantVariety> plantVariety()
    {
        if (plantVarietyId <= 0)
            return Optional.empty();
        return Optional.ofNullable(MySQLCache.cachePlantVariety.get(plantVarietyId));
    }

    @Override
    public Optional<ILocation> location()
    {
        if (locationId <= 0)
            return Optional.empty();
        return Optional.ofNullable(MySQLCache.cacheLocation.get(locationId));
    }

}
