/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	Change log
	2.0.1   Speed up reading PlantVarieties.
 */

package uk.co.gardennotebook.mysql;

import uk.co.gardennotebook.spi.*;

import java.util.HashMap;

/**
*	Caches data read from the database.  This enables faster access and easy updating.
*@apiNote
*	The main benefit is that there is at most one instance of each data object
*	so any changes can be easily signalled to all displaying objects.
*
*	@author	Andy Gegg
*	@version	1.0
*	@since	1.0
*/

final class MySQLCache
{
	private MySQLCache() {}

	static HashMap<Integer, IProductCategory> cacheProductCategory = new HashMap<>();
	static boolean completeProductCategory = false;
	static boolean invalidProductCategory = true;

	static HashMap<Integer, IShoppingList> cacheShoppingList = new HashMap<>();
	static boolean completeShoppingList = false;

	static HashMap<Integer, IPurchaseItem> cachePurchaseItem = new HashMap<>();
	static boolean completePurchaseItem = false;

	static HashMap<Integer, IWildlifeSpecies> cacheWildlifeSpecies = new HashMap<>();
	static boolean completeWildlifeSpecies = false;
	static boolean invalidWildlifeSpecies = true;

	static HashMap<Integer, IGroundworkActivity> cacheGroundworkActivity = new HashMap<>();
	static boolean completeGroundworkActivity = false;
	static boolean invalidGroundworkActivity = true;

	static HashMap<Integer, IGroundwork> cacheGroundwork = new HashMap<>();
	static boolean completeGroundwork = false;

	static HashMap<Integer, IAfflictionClass> cacheAfflictionClass = new HashMap<>();
	static boolean completeAfflictionClass = false;
	static boolean invalidAfflictionClass = true;

	static HashMap<Integer, IWeather> cacheWeather = new HashMap<>();
	static boolean completeWeather = false;

	static HashMap<Integer, IRetailerHasProduct> cacheRetailerHasProduct = new HashMap<>();
	static boolean completeRetailerHasProduct = false;

	static HashMap<Integer, IProductBrand> cacheProductBrand = new HashMap<>();
	static boolean completeProductBrand = false;

	static HashMap<Integer, IHusbandryClass> cacheHusbandryClass = new HashMap<>();
	static boolean completeHusbandryClass = false;
	static boolean invalidHusbandryClass = true;

	static HashMap<Integer, IAffliction> cacheAffliction = new HashMap<>();
	static boolean completeAffliction = false;

	static HashMap<Integer, IWildlife> cacheWildlife = new HashMap<>();
	static boolean completeWildlife = false;

	static HashMap<Integer, IProduct> cacheProduct = new HashMap<>();
	static boolean completeProduct = false;

	static HashMap<Integer, IReminder> cacheReminder = new HashMap<>();
	static boolean completeReminder = false;

	static HashMap<Integer, IRetailer> cacheRetailer = new HashMap<>();
	static boolean completeRetailer = false;
	static boolean invalidRetailer = true;

	static HashMap<Integer, IPurchase> cachePurchase = new HashMap<>();
	static boolean completePurchase = false;

	static HashMap<Integer, IPlantVariety> cachePlantVariety = new HashMap<>();
    /**
     * This allows an easy look-up of varieties for a species without a lot of redundant DB accesses.
     * The outer HashMap is keyed on plantSpeciesId; the inner HashMap is keyed on plantVarietyId.
     * An absent plantSpeciesId means the PS has not been used; a null or empty inner map means there are no varieties.
     */
    static HashMap<Integer, HashMap<Integer, IPlantVariety>> cacheVarietyBySpecies = new HashMap<>();
	static boolean completePlantVariety = false;

	static HashMap<Integer, IAfflictionEvent> cacheAfflictionEvent = new HashMap<>();
	static boolean completeAfflictionEvent = false;

	static HashMap<Integer, IPlantNote> cachePlantNote = new HashMap<>();
	static boolean completePlantNote = false;

	static HashMap<Integer, IHusbandry> cacheHusbandry = new HashMap<>();
	static boolean completeHusbandry = false;

	static HashMap<Integer, IToDoList> cacheToDoList = new HashMap<>();
	static boolean completeToDoList = false;

	static HashMap<Integer, IWeatherCondition> cacheWeatherCondition = new HashMap<>();
	static boolean completeWeatherCondition = false;
	static boolean invalidWeatherCondition = true;

	static HashMap<Integer, IPlantSpecies> cachePlantSpecies = new HashMap<>();
	static boolean completePlantSpecies = false;
	static boolean invalidPlantSpecies = true;

	static HashMap<Integer, ISale> cacheSale = new HashMap<>();
	static boolean completeSale = false;

	static HashMap<Integer, ISaleItem> cacheSaleItem = new HashMap<>();
	static boolean completeSaleItem = false;

	static HashMap<Integer, ILocation> cacheLocation = new HashMap<>();
	static boolean completeLocation = false;
	static boolean invalidLocation = true;

	static HashMap<Integer, IJournal> cacheJournal = new HashMap<>();
	static boolean completeJournal = false;
//	static boolean invalidJournal = true;

	static HashMap<Integer, IReview> cacheReview = new HashMap<>();
	static boolean completeReview = false;
//	static boolean invalidReview = true;

	static HashMap<Integer, IReviewReferences> cacheReviewReferences = new HashMap<>();
	static boolean completeReviewReferences = false;
//	static boolean invalidReviewReferences = true;

	static HashMap<Integer, ICropRotationGroup> cacheCropRotationGroup = new HashMap<>();
	static boolean completeCropRotationGroup = false;
	static boolean invalidCropRotationGroup = true;

	static HashMap<Integer, ICroppingPlan> cacheCroppingPlan = new HashMap<>();
	static boolean completeCroppingPlan = false;
	static boolean invalidCroppingPlan = true;

	static HashMap<Integer, ICroppingActual> cacheCroppingActual = new HashMap<>();
	static boolean completeCroppingActual = false;
	static boolean invalidCroppingActual = true;

}
